/*  Code for Monte Carlo class

http://www.math.nyu.edu/faculty/goodman/teaching/MonteCarlo15/ClassHomePage.php.html

The author gives permission for anyone to use this publically posted 
code for any purpose.  The code was written for teaching, not research 
or commercial use.  It has not been tested thoroughly and probably has
serious bugs.  Results may be inaccurate, incorrect, or just wrong. */


/*  Main program to test assignment 1.
    Driver for a direct sampler in file f.cpp.       
    Set data, call the sampler, write the results to a Python file. */

#include "header.h"


int main(){
  
  static unsigned long seed = 17;      // Set the seed of the random number generator.
  sgenrand ( seed);                    // Do this once only.
  
  int       L = 10000;    // Number of samples
  double x_min = 0.;      // Range for output histogram, left end of the first bin
  double x_max = 1.;      // Range for output histogram, right end of the last bin
  double dx   = .05;      // suggested bin size for output histogram (may be adjusted a little)
  int    nb   = (x_max - x_min)/dx;   //  an integer, the number of bins
         dx   = (x_max - x_min)/nb;   //  adjust the bin size to fit exactly.
  string Experiment = fString();      //  A string describing the random variable you're trying to
                                      //  generate, for plot labels.
  
  double * X;         // Array of samples
  int    * N;         // Array of bin counts
  X = new double[L];  // Get memory for the sample array, L = number of samples
  N = new int[nb];    // Get memory for the histogram array, nb = number of bins
  
  for ( int j = 0; j < nb; j++)   // Initialize the bin count array.
    N[j] = 0;  
  
  int j;                                  // bin index
  for ( int k = 0; k < L; k++) {
  
    X[k]  = fSamp();                      // Call the sampler
    
    if ( ( X[k] > x_min ) && ( X[k] < x_max ) ) {   // do not bin samples outside the histogram range
      j = ( X[k] - x_min )/dx;            // Bin j is the interval [ x_min + j*dx, x_min + (j+1)*dx ]
      N[j]++;                            // increment the bin count
     }
   }
  
  double * f_hat;                       //  estimate of f from bin counts
  double * f_Bar;                       //  The average of the true f in bin j
  f_hat = new double[nb];               //  Allocate
  f_Bar = new double[nb];
  double xl, xr;                       //  Bin j is [xl,xr]
  xl = x_min;                          //  Start with the left most bin.
  xr = xl + dx;
  
  double p;                            //  for the error bar.  p = prob(X in bin j)
  double epsN;                         //  epsN = standard deviation of N (estimate)
  double * epsf;                       //  epsf = standard deviation of fhat
  epsf = new double[nb];
  for (j = 0; j < nb; j++) {
    f_hat[j] = N[j]/(L*dx);
    f_Bar[j] = fInt( xl, xr);
    xl     += dx;                       //  Move to the next bin
    xr     += dx;
    
    p       = ( (double) N[j]) / L;     //  The fraction of hits in bin j
    epsN    = L*p*(1-p);                //  estimated variance of N[j]
    epsN    = sqrt( epsN );             //  estimated standard deviation
    epsf[j] = sqrt( p*(1-p)/(dx*dx*L));
   }
  
  
  ofstream plotInfo;                  // Internal name of the plot file
  plotInfo.open ("plotInfo.py");      // Open, and give an external name
  
  plotInfo << " " << endl;            //  Write a comment at the top of the output file
  plotInfo << "#  Output file plotInfo.py.  See main.cpp for more info" << endl;
  plotInfo << " " << endl;
  
  std::string pyIndent = "   ";       // One indententation in python
  plotInfo <<             "import numpy as np"      << endl;
  plotInfo <<             "def RunData():"          << endl;
  plotInfo << pyIndent << "L = " << L               << endl;
  plotInfo << pyIndent << "data = { 'L' : L } "     << endl;  // data is a python dictionary
  
  plotInfo << pyIndent << "xmin = " << x_min         << endl; // python code giving xmin a value
  plotInfo << pyIndent << "data[ 'xmin' ] = xmin "  << endl;  // python code to add xmin to the dictionary
  plotInfo << pyIndent << "dx = " << dx             << endl;
  plotInfo << pyIndent << "data[ 'dx' ]   = dx "    << endl;
  plotInfo << pyIndent << "nb = " << nb             << endl;
  plotInfo << pyIndent << "data[ 'nb' ]   = nb "    << endl;
  plotInfo << pyIndent << "Experiment = \'" << Experiment  << "\'"    << endl;
  plotInfo << pyIndent << "data[ 'Experiment' ]   = Experiment "    << endl;
    
  PyWrite( f_hat, "fhat", pyIndent, 1, nb, plotInfo);     // PyWrite adds an array to the output dictionary
  PyWrite( f_Bar, "fBar", pyIndent, 1, nb, plotInfo);
  PyWrite( epsf, "epsf", pyIndent, 1, nb, plotInfo);
  
  plotInfo << pyIndent << "return data"             << endl;
  
  plotInfo.close();
  
  return 0;
 }