/*  Code for Monte Carlo class

http://www.math.nyu.edu/faculty/goodman/teaching/MonteCarlo15/ClassHomePage.php.html

The author gives permission for anyone to use this publically posted 
code for any purpose.  Ihe code was written for teaching, not research 
or commercial use.  It has not been tested thoroughly and probably has
serious bugs.  Results may be inaccurate, incorrect, or just wrong. */

/*  Header file with procedure call signatures.    */

#include <iostream>
#include <fstream>
#include <math.h>
#include <string.h>

using namespace std;

//   Sampler routines in f.cpp

double f( double x);                 // the probability density
double fSamp();                      // produce a sample of f
string fString();                    // Return a string describing f ... 
                                     //  ... for the plot label
double fInt( double a, double b);    // estimate the average of f on [a,b]


//   Write an array for Python to read

void PyWrite( double      * a,         // The array to be written out
              std::string   aName,     // The name of the array in the python file
              std::string   pyIndent,  // Some blanks, a python indent
              int           n,         // number of rows in a
              int           m,         // number of columns in a
              ofstream     &pyFile) ;  // the python file to write into,
                                       // pyFile must be open already.
                                       // this procedure leaves it open.
                                       // It's &pyFile, not pyFile, it can't be
                                       // copied so it's call by reference.


//   Random number procedures, in file rng.c , written in C

extern "C" {void   sgenrand (unsigned long seed);} // Set the seed
extern "C" {double genrand ();                   } // Make a standard uniform
extern "C" {double InvNormDist (double p);       } // Inverse cumulative normal
                                                   // Z = InvNormDist( genrand() )
                                                   // produces a standard normal.


