/*  Code for Monte Carlo class
http://www.math.nyu.edu/faculty/goodman/teaching/MonteCarlo15/ClassHomePage.php.html

The author gives permission for anyone to use this publicly posted 
code for any purpose.  The code was written for teaching, not research 
or commercial use.  It has not been tested thoroughly and probably has
serious bugs.  Results may be inaccurate, incorrect, or just wrong. */


/*  The sampler and definition of the PDF being sampled.        */

//       6*x*(1-x) sampled using the middle of 3 uniforms

#include "header.h"


double f( double x){    // The definition of the PDF being sampled

  if ( x < 0. ) {
    return 0.;
   }
  
  if ( x > 1. ) {
    return 0.;
   }
  return 6*x*(1.-x);
    
  return 0;
 }


double fSamp() {      // A direct sampler for the f density

  double U1, U2, U3, Ut;  // three uniforms, and a temp for swapping
  U1 = genrand();
  U2 = genrand();
  U3 = genrand();
  if ( U1 > U2 ) {   // Swap U1 <--> U2 so U2 becomes larger than U1
    Ut = U1;
    U1 = U2;
    U2 = Ut;
   }
  if ( U2 > U3 ) {   // Swap U2 <--> U3 so U3 becomes larger than U2
    Ut = U2;
    U2 = U3;
    U3 = Ut;
   }
  if ( U1 > U2 ) {   // Swap U1 <--> U2 so U2 becomes larger than U1
    Ut = U1;
    U1 = U2;
    U2 = Ut;
   }
  
  return U2;
    
  return genrand();
 }


string fString(){     //  Return a string describing f, for the plot label
  return "6*x*(1-x), X = U_(2) ";
 }



// Estimate (1/(b-a) \int_a^b f(x) dx, use the 2-nd order midpoint rule.

double fInt( double a, double b) { // Quick and dirty integrator.

  int    n  = 100;          // number of points for integration.
  double dx = (b - a)/n;    // The size of an integration interval
  double x;                 // center of an integration interval
  int    j;                 // index for the integration interval
  
  double fBar;              // The answer
  
  fBar = 0.;
  x = a + .5*dx;            // Center of the left most integration interval
  for ( j = 0; j < n; j++ ) {
    fBar += f(x);
    x    += dx;      // Move to the center of the next interval
   }
  fBar = fBar * dx;  //  Now it's an approximation to the integral from a to b
  fBar = fBar/(b-a); //  Now it's an approximation to the average of f in [a,b]
  return fBar;
 }
  
  
  
  