#  Code for Monte Carlo class

#  http://www.math.nyu.edu/faculty/goodman/teaching/MonteCarlo12/ClassHomePage.php.html

#  The author gives permission for anyone to use this publicly posted 
#  code for any purpose.  The code was written for teaching, not research
#  or commercial use.  It has not been tested thoroughly and probably has
#  serious bugs.  Results may be inaccurate, incorrect, or just wrong. */



import plotInfo as PI
import numpy as np
import matplotlib.mlab as mlab
import matplotlib.pyplot as plt
import string as st

#   copy the data elements to interman python variables with the same names

data       = PI.RunData() 
L          = data['L']            #  The number of samples
nb         = data['nb']           #  The number of bins
dx         = data['dx']           #  The bin size
xmin       = data['xmin']         #  The left end of first bin
fhat       = data['fhat']         #  Estimates of f: bin counts normalized by L
fBar       = data['fBar']         #  fBar[j] = average of f over bin j
epsf       = data['epsf']         #  error bar for fhat
Experiment = data['Experiment']   #  a character string describing f


x     = np.zeros( nb, np.float64)    #  x[j] = center of bin j, starting with x[0].
fhatv = np.zeros( nb, np.float64)    #  copy arrays so they all have the same dimension, for plotting
fBarv = np.zeros( nb, np.float64)
epsfv = np.zeros( nb, np.float64)
for j in range(0,nb):
  x[j]     = xmin + dx*(j + .5)
  fhatv[j] = fhat[0,j]
  fBarv[j] = fBar[0,j]
  epsfv[j] = epsf[0,j]

#     plot the 

p1,= plt.plot(    x, fBarv, color = 'k',                label = 'exact f',   linewidth=1)
p2,= plt.plot(    x, fhatv, color = 'b', marker = 's',  label = 'sampler f', linewidth = 0,)
plt.errorbar(x, fhatv, yerr=epsfv, fmt = 'b.',     label = 'error bar')
titleString = Experiment + ', L =  %(L)8d, dx = %(dx)7.3f' % \
                            {"L": L,      "dx":dx}
plt.title(titleString)
plt.grid(True)
plt.xlabel('x')
plt.ylabel('f')
plt.legend( [p1,p2], ['Exact, bin averaged', 'Sampled, with error bars'], loc = 'best')
figureFileName ='Week1.pdf'
plt.savefig(figureFileName)
plt.show()
                                                          
