/*  Code for Monte Carlo class

http://www.math.nyu.edu/faculty/goodman/teaching/MonteCarlo12/ClassHomePage.php.html

The author gives permission for anyone to use this publically posted 
code for any purpose.  The code was written for teaching, not research 
or commercial use.  It has not been tested thoroughly and probably has
serious bugs.  Results may be inaccurate, incorrect, or just wrong. */


/*  Main program to test a direct sampler in file f.cpp.        */

#include "header.h"


int main(){
  
  cout << "hello world" << endl;
  
  double x, ff;
  x = .5;
  ff = f(x);
  cout << "f(" << x << ") = " << ff << endl;
  
  static unsigned long seed = 17;
  sgenrand ( seed);
  
  int      L = 10000;        // Number of samples
  double xmin = 0.;       // left end of the first bin
  double xmax = 1.;       // right end of the last bin
  double dx   = .05;   // the suggested bin size
  int    nb   = (xmax - xmin)/dx;    //  an integer, the number of bins
         dx   = (xmax - xmin)/nb;    //  adjust the bin size to fit exactly.
  string Experiment = fString();     // A string saying what random variable
                                        // you're trying to generate,
                                        // for the plot.
  
  double * X;         // Array of samples
  X = new double[L];  // Get memory for the array
  int    * N;         // Array of bin counts
  N = new int[nb];
  for ( int j = 0; j < nb; j++)
    N[j] = 0;  
  
  int j;                                  // bin index
  for ( int k = 0; k < L; k++) {
    X[k]  = fSamp();
    if ( ( X[k] > xmin ) && ( X[k] < xmax ) ) {
      j = ( X[k] - xmin )/dx;            // automatically rounded down
      N[j]++;                            // increment the bin count
     // cout << "Sample " << k << " is " << X[k] << " in bin " << j << endl;
     }
   }
  
  double * fhat;                       //  estimate of f from bin counts
  fhat = new double[nb];               //  allocate fhat
  double * fBar;                       //  The average of f in bin j
  fBar = new double[nb];
  double xl, xr;                       //  Bin j is [xl,xr]
  xl = xmin;                           //  Start with the left most bin.
  xr = xl + dx;
  
  double p;                            //  for the error bar.  p = prob(bin j)
  double epsN;                         //  epsN = standard deviation of N (estimate)
  double * epsf;                       //  epsf = standard deviation of fhat
  epsf = new double[nb];
  for (j = 0; j < nb; j++) {
    fhat[j] = N[j]/(L*dx);
    fBar[j] = fInt( xl, xr);
    xl     += dx;                       //  Move to the next bin
    xr     += dx;
    
    p       = ( (double) N[j]) / L;     //  The fraction of hits in bin j
    epsN    = L*p*(1-p);                //  estimated variance of N[j]
    epsN    = sqrt( epsN );             //  estimated standard deviation
    epsf[j] = sqrt( p*(1-p)/(dx*dx*L));
   }
  
  
  ofstream plotInfo;                  // Internal name of the plot file
  plotInfo.open ("plotInfo.py");      // Open, and give an external name
  
  std::string pyIndent = "   ";       // One indententation in python
  plotInfo <<             "import numpy as np"      << endl;
  plotInfo <<             "def RunData():"          << endl;
  plotInfo << pyIndent << "L = " << L               << endl;
  plotInfo << pyIndent << "data = { 'L' : L } "     << endl;
  
  plotInfo << pyIndent << "xmin = " << xmin         << endl;
  plotInfo << pyIndent << "data[ 'xmin' ] = xmin "  << endl;
  plotInfo << pyIndent << "dx = " << dx             << endl;
  plotInfo << pyIndent << "data[ 'dx' ]   = dx "    << endl;
  plotInfo << pyIndent << "nb = " << nb             << endl;
  plotInfo << pyIndent << "data[ 'nb' ]   = nb "    << endl;
  plotInfo << pyIndent << "Experiment = \'" << Experiment  << "\'"    << endl;
  plotInfo << pyIndent << "data[ 'Experiment' ]   = Experiment "    << endl;
    
  PyWrite( fhat, "fhat", pyIndent, 1, nb, plotInfo);
  PyWrite( fBar, "fBar", pyIndent, 1, nb, plotInfo);
  PyWrite( epsf, "epsf", pyIndent, 1, nb, plotInfo);
  
  plotInfo << pyIndent << "return data"             << endl;
  
  plotInfo.close();
  
  return 0;
 }