/*  Code for Monte Carlo class

http://www.math.nyu.edu/faculty/goodman/teaching/MonteCarlo12/ClassHomePage.php.html

The author gives permission for anyone to use this publically posted 
code for any purpose.  The code was written for teaching, not research 
or commercial use.  It has not been tested thoroughly and probably has
serious bugs.  Results may be inaccurate, incorrect, or just wrong. */


/*  Main program to for the separation model in the Week 2 class notes     */

#include "header.h"


int main(){
  
  cout << "hello world" << endl;
  
//   Physical parameters
  
  int     n  = 50;    // The lattice size
  double be  = 2.;    // The constant in the exponent, beta = 1/(k_B T)
  double rho = .4;    // The volume fraction of occupied sites, approximate
  
//    Computational parameters

  int T  = 1000000000;       // The total number of MCMC steps
  int Tr = 50000000;       // The number of MCMC samples between reports
  
//    Initialize the random number generator before doing anything else.
  
  static unsigned long seed = 17;     
  sgenrand ( seed);
  
  int i, j, k, t;              // generic integers
  
//    Initialize by occupying the first n^2*rho sites in the lattice.
  
  int * X;                     // An n X n lattice of occupation variables
  X = new int[(n+2)*(n+2)];

  Xinit( X, rho, n);
  Xprint( X, n);
  double fc, phi;                   // computed probability, resulting energy
  fc = f(X, be, n);
  phi = - log(fc)/be;
  cout << "probability = " << fc << ", energy = " << phi << endl;
  
  for ( t = 0; t < T; t++) {
  
    fSamp(X, be, n);
    
    if (  ( ( t % Tr ) == 0 )    // Stop to gather data every Tr steps
         && (   t > 0 ) ) {      // but not the first time
       Xprint( X, n);
       cout << endl;
     }
   }
  
  return 0;
 }